#ifndef _CONVERTER_H_
#define _CONVERTER_H_

#include <buildspec.h>

#include <boost/algorithm/string.hpp>
#include <string>
#include <vector>

namespace GST
{
namespace Utils
{

/**
 * A class for conversion functions.
 */
class GST_API_EXPORT Converter
{
	static bool random_is_initialised;

public:
	static std::string randomStrGen(int length);
	static float roundf(const float &r);
	static int generateRandomNumber(int first, int last);
	static bool StringToBool(const std::string &str);
	static bool WildcardCompare(const char *wild, const char *string);
};

struct GST_API_EXPORT UpperCaseCompare{bool operator()(
	const std::string &s1,
	const std::string &s2) const {return boost::algorithm::to_upper_copy(s1)
										 < boost::algorithm::to_upper_copy(s2);
} // namespace Utils
}; // namespace GST

// note: a wildcardExpression is a ';' separated list with each part being a
// string of alphanumerical characters, with '?' or '*' as wildcard
// characters
class GST_API_EXPORT WildcardExpressionComparer
{
public:
	WildcardExpressionComparer(const std::string &wildcardExpression);
	std::string getWilcardExpression() const;
	void setWilcardExpression(const std::string &wildcardExpression);
	bool matchesWildcardExpression(const std::string &value) const;

private:
	std::vector<std::string> m_wildcardExpressionParts;
	std::string m_wildcardExpression;
};
} // namespace Utils
} // namespace GST

#endif //_CONVERTER_H_
